% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dbplyr-db.R
\name{db_list_tables.PrestoConnection}
\alias{db_list_tables.PrestoConnection}
\alias{db_has_table.PrestoConnection}
\alias{db_write_table.PrestoConnection}
\alias{db_copy_to.PrestoConnection}
\alias{db_compute.PrestoConnection}
\alias{db_save_query.PrestoConnection}
\alias{db_sql_render.PrestoConnection}
\title{dbplyr database methods}
\usage{
\method{db_list_tables}{PrestoConnection}(con)

\method{db_has_table}{PrestoConnection}(con, table)

\method{db_write_table}{PrestoConnection}(
  con,
  table,
  types,
  values,
  temporary = FALSE,
  overwrite = FALSE,
  ...,
  with = NULL
)

\method{db_copy_to}{PrestoConnection}(
  con,
  table,
  values,
  overwrite = FALSE,
  types = NULL,
  temporary = TRUE,
  unique_indexes = NULL,
  indexes = NULL,
  analyze = TRUE,
  ...,
  in_transaction = TRUE,
  with = NULL
)

\method{db_compute}{PrestoConnection}(
  con,
  table,
  sql,
  temporary = TRUE,
  unique_indexes = list(),
  indexes = list(),
  analyze = TRUE,
  with = NULL,
  ...
)

\method{db_save_query}{PrestoConnection}(
  con,
  sql,
  name,
  temporary = TRUE,
  overwrite = FALSE,
  ...,
  with = NULL
)

\method{db_sql_render}{PrestoConnection}(con, sql, ..., use_presto_cte = TRUE)
}
\arguments{
\item{con}{A \code{PrestoConnection} as returned by \code{dbConnect()}.}

\item{table}{Table name}

\item{types}{Column types. If not provided, column types are inferred using
dbDataType.}

\item{values}{A \code{data.frame}.}

\item{temporary}{If a temporary table should be created. Default to TRUE in
the \code{\link[dplyr:backend_dbplyr]{dplyr::db_save_query()}} generic. The default value generates an error
in Presto. Using \code{temporary = FALSE} to save the query in a permanent
table.}

\item{overwrite}{If an existing table should be overwritten. Default to
FALSE. When TRUE, uses smart overwriting: renames the existing table,
creates the new table, and drops the old table on success. If creation
fails, the original table is restored.}

\item{...}{Extra arguments to be passed to individual methods.}

\item{with}{An optional WITH clause for the CREATE TABLE statement.}

\item{unique_indexes, indexes, analyze, in_transaction}{Ignored. Included
for compatibility with generics.}

\item{sql}{A SQL statement.}

\item{name}{The table name, passed on to
\code{\link[DBI:dbQuoteIdentifier]{DBI::dbQuoteIdentifier()}}. Options are: a character string with the
unquoted DBMS table name, a call to \code{\link[DBI:Id]{DBI::Id()}} with components to the
fully qualified table name, or a call to \code{\link[DBI:SQL]{DBI::SQL()}} with the quoted and
fully qualified table name given verbatim.}

\item{use_presto_cte}{A logical value indicating if to use common table expressions stored in
PrestoConnection when possible. Default to TRUE. See
\code{vignette("common-table-expressions")}.}
}
\description{
dbplyr database methods
}
