% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_czek_matrix.R
\name{manual_reorder}
\alias{manual_reorder}
\title{Manually reorder  Czekanowski's Diagram}
\usage{
manual_reorder(x, v_neworder, ...)
}
\arguments{
\item{x}{a matrix with class czek_matrix, czek_matrix_dist or data matrix/data.frame or dist object.}

\item{v_neworder}{a numeric vector with the new ordering.}

\item{...}{specifies further parameters that will be passed to the czek_matrix function.}
}
\value{
The function returns a Czekanowski's Diagram with the new order and recalculated factors.
}
\description{
This is a function that allows the user to manully reorder Czekanowski's Diagram and recalculates all the factors.
}
\examples{
# Set data ####
x<-mtcars

# Calculate Czekanowski's diagram
czkm<-czek_matrix(x)
czkm_dist<-czek_matrix(x,as_dist=TRUE)
# new ordering
neworder<-attr(czkm,"order")
neworder[1:2]<-neworder[2:1]
# reorder the diagram
#if the output was Czekanowski's diagram without the distances
#remembered, then the original data has to be passed so that 
#factors can be recalculated.
new_czkm<-manual_reorder(czkm,v_neworder=neworder,orig_data=x)
new_czkm_dist<-manual_reorder(czkm_dist,v_neworder=neworder)
#we can also pass the original data directly
new_czkm<-manual_reorder(x,v_neworder=neworder)
#and this is equivalent to calling
czkm<-czek_matrix(x,order=neworder)
#up to the value of the "criterion_value" attribute
#which in the second case can be lost, as no information is passed
#on which one was originally used, while in the first case it might
#be impossible to recalculate-only criteria values from seriate are supported
#if a user has a custom seriation function, then they need to recalculate this
#value themselves
}
