% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/retrieveBest.R
\name{retrieveBest}
\alias{retrieveBest}
\title{REMixed results}
\usage{
retrieveBest(fit, criterion = BICc)
}
\arguments{
\item{fit}{output of \code{\link{cv.remix}};}

\item{criterion}{which criterion function to take into account. Default is the function 'BICc", but one can use 'BIC', 'AIC', 'eBIC' or any function depending on a `cvRemix` object.}
}
\value{
outputs from \code{\link{remix}} algorithm achieving the best IC among those computed by \code{\link{cv.remix}}.
}
\description{
Extracts the build minimizing an information criterion over a grid of lambda.
}
\examples{
\dontrun{
project <- getMLXdir()

ObsModel.transfo = list(S=list(AB=log10),
                        linkS="yAB",
                        R=rep(list(S=function(x){x}),5),
                        linkR = paste0("yG",1:5))

alpha=list(alpha0=NULL,
           alpha1=setNames(paste0("alpha_1",1:5),paste0("yG",1:5)))

y = c(S=5,AB=1000)

cv.outputs = cv.Remix(project = project,
            dynFUN = dynFUN_demo,
            y = y,
            ObsModel.transfo = ObsModel.transfo,
            alpha = alpha,
            selfInit = TRUE,
            eps1=10**(-2),
            ncores=8,
            eps2=1)

res <- retrieveBest(cv.outputs)

plotConvergence(res)

trueValue = read.csv(paste0(dirname(project),"/demoSMLX/Simulation/populationParameters.txt"))#'

plotSAEM(res,paramToPlot = c("delta_S_pop","phi_S_pop","delta_AB_pop"),trueValue=trueValue)
}
}
\seealso{
\code{\link{cv.remix}}, \code{\link{remix}}, \code{\link{BIC.remix}}, \code{\link{eBIC}}, \code{\link{AIC.remix}}, \code{\link{BICc}}.
}
