% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_gompertz.R
\name{plot_joint_survival}
\alias{plot_joint_survival}
\title{Plotting the results of Gompertz model calibration for joint survival}
\usage{
plot_joint_survival(params, include_gompertz = FALSE)
}
\arguments{
\item{params}{A list returned by \code{\link[=calc_gompertz_joint_parameters]{calc_gompertz_joint_parameters()}} function.}

\item{include_gompertz}{A logical. Should the Gompertz survival curve be included in the plot?}
}
\value{
A \code{\link[ggplot2:ggplot]{ggplot2::ggplot()}} object showing the survival probabilities
for two individuals and their joint survival probability.
}
\description{
Plotting the results of Gompertz model calibration for joint survival
}
\examples{
params <- calc_gompertz_joint_parameters(
  p1 = list(
    age        = 65,
    mode       = 88,
    dispersion = 10.65
  ),
  p2 = list(
    age        = 60,
    mode       = 91,
    dispersion = 8.88
  ),
  max_age = 110
)

plot_joint_survival(params = params, include_gompertz = TRUE)
}
