% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/S3Summary.R
\name{summary}
\alias{summary}
\alias{summary.CDM}
\alias{summary.validation}
\alias{summary.sim.data}
\alias{summary.fit}
\alias{summary.is.Qident}
\alias{summary.att.hierarchy}
\title{Summary Methods for Various Objects}
\usage{
\method{summary}{CDM}(object, ...)

\method{summary}{validation}(object, ...)

\method{summary}{sim.data}(object, ...)

\method{summary}{fit}(object, ...)

\method{summary}{is.Qident}(object, ...)

\method{summary}{att.hierarchy}(object, ...)
}
\arguments{
\item{object}{An object of class \code{\link[Qval]{CDM}}, \code{\link[Qval]{validation}}, 
\code{\link[Qval]{sim.data}}, \code{\link[Qval]{fit}}, or \code{\link[Qval]{is.Qident}}.}

\item{...}{Currently unused. Additional arguments are ignored.}
}
\value{
A named list with class \code{summary.<class>} containing the components above.
}
\description{
Generate concise summary statistics for objects created by the \code{Qval} package.
The output is a named list tailored to the class of the input:
\describe{
  \item{\code{\link[Qval]{CDM}}}{contains the original call, dataset dimensions, model fit object, and attribute-pattern distribution.}
  \item{\code{\link[Qval]{validation}}}{contains the original call, suggested Q-matrix, and original Q-matrix.}
  \item{\code{\link[Qval]{sim.data}}}{contains the original call, dataset dimensions, and attribute-pattern distribution.}
  \item{\code{\link[Qval]{fit}}}{contains the original call, relative fit indices and absolute fit indices.}
  \item{\code{\link[Qval]{is.Qident}}}{contains the original call and results of whether the Q-matrix is identifiable.}
  \item{\code{\link[Qval]{att.hierarchy}}}{contains the results of iterative attribute hierarchy exploration.}
}
}
\section{Methods (by class)}{
\itemize{
\item \code{summary(CDM)}: Summary method for \code{CDM} objects

\item \code{summary(validation)}: Summary method for \code{validation} objects

\item \code{summary(sim.data)}: Summary method for \code{sim.data} objects

\item \code{summary(fit)}: Summary method for \code{fit} objects

\item \code{summary(is.Qident)}: Summary method for \code{is.Qident} objects

\item \code{summary(att.hierarchy)}: Summary method for \code{att.hierarchy} objects

}}
\examples{
set.seed(123)
library(Qval)

\donttest{
################################################################
# Example 1: summary a CDM object                              #
################################################################
Q <- sim.Q(3, 20)
IQ <- list(P0 = runif(20, 0, 0.2), P1 = runif(20, 0.8, 1))
data.obj <- sim.data(Q, N = 500, IQ = IQ, 
                     model = "GDINA", distribute = "horder")
CDM.obj <- CDM(data.obj$dat, Q, model = "GDINA", method = "EM")
summary(CDM.obj)


################################################################
# Example 2: summary a validation object                       #
################################################################
MQ <- sim.MQ(Q, 0.1)
CDM.obj2 <- CDM(data.obj$dat, MQ)
val.obj <- validation(data.obj$dat, MQ, CDM.obj2, method = "GDI")
summary(val.obj)


################################################################
# Example 3: summary a sim.data object                         #
################################################################
data.obj2 <- sim.data(Q = sim.Q(3, 10), N = 1000)
summary(data.obj2)

################################################################
# Example 4: summary a fit object                         #
################################################################
fit.obj <- fit(data.obj$dat, Q, model="GDINA")
summary(fit.obj)
}

}
