% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RG_to_igraph.R
\name{RG_to_igraph}
\alias{RG_to_igraph}
\title{Converts a relationship graph (RG) encoded as a list to an \code{igraph} object}
\usage{
RG_to_igraph(RG, MOIs)
}
\arguments{
\item{RG}{List encoding an RG; see \strong{Value} of
\code{\link{enumerate_RGs}} when \code{igraph = FALSE}.}

\item{MOIs}{Vector of per-episode multiplicities of infection (MOIs), i.e.,
numbers of per-episode genotypes / vertices; adds to the graph an attribute
that is used by \code{\link{plot_RG}} to group genotypes / vertices by episode.}
}
\value{
A weighted graph whose edge weights 1 and 0.5 encode clonal and
sibling relationships, respectively.
}
\description{
Converts an RG encoded as a list to an \code{igraph} object, which requires
more memory allocation but can be plotted using \code{\link{plot_RG}}.
}
\examples{
MOIs <- c(3,2)
set.seed(6)
RG_as_list <- sample_RG(MOIs, igraph = FALSE)
RG_as_igraph <- RG_to_igraph(RG_as_list,  MOIs)

# RG encoded as a list requires less memory allocation
utils::object.size(RG_as_list)
utils::object.size(RG_as_igraph)

# RG encoded as an igraph object can be plotted using plot_RG() and
# manipulated using igraph functions
plot_RG(RG_as_igraph, margin = rep(0,4), vertex.label = NA)

# Edge weights 1 and 0.5 encode clonal and sibling relationships
igraph::E(RG_as_igraph)$weight

# Vertex attribute group encodes episode membership
igraph::V(RG_as_igraph)$group

}
