% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ml.R
\name{panel_returns_simple}
\alias{panel_returns_simple}
\title{Panel simple returns from prices}
\usage{
panel_returns_simple(prices)
}
\arguments{
\item{prices}{A data frame or data.table with columns \code{Date} and one column
per symbol containing adjusted prices at a common frequency (daily, weekly, monthly).}
}
\value{
A data frame with \code{Date} and one column per symbol containing simple returns
\eqn{R_{t} = P_{t}/P_{t-1} - 1}.
}
\description{
Converts a wide price panel (Date + symbols) into arithmetic simple returns
at the same cadence, dropping the first row per symbol.
}
\examples{
\donttest{
  data(sample_prices_weekly)
  rets <- panel_returns_simple(sample_prices_weekly)
  head(rets)
}

}
