% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ml_helper.R
\name{ml_prepare_features}
\alias{ml_prepare_features}
\title{Prepare tabular features (weekly + aligned daily volatility)}
\usage{
ml_prepare_features(
  prices_weekly,
  prices_daily = NULL,
  include = c("mom12", "mom26", "mom52", "vol20d_walign", "dist20", "rsi14"),
  interactions = NULL
)
}
\arguments{
\item{prices_weekly}{Wide panel with \code{Date} and symbol columns (weekly).}

\item{prices_daily}{Optional wide panel (daily) if \code{vol*d_walign} are included.}

\item{include}{Character vector of feature tokens to include.}

\item{interactions}{Optional named list passed to \code{\link[=ml_add_interactions]{ml_add_interactions()}}.}
}
\value{
A named list of panels (each a wide data.frame with \code{Date}).
}
\description{
Constructs a minimal, leakage-safe set of tabular features commonly used
in cross-sectional ML: weekly momentum (12/26/52), RSI(14), distance from
20-week MA, and daily rolling volatility aligned to weekly dates
(tokens \verb{vol\{N\}d_walign}, e.g., \code{"vol20d_walign"}).
}
\details{
All outputs are \strong{lagged by one period} to avoid look-ahead in backtests.
}
\examples{
\dontrun{
X <- ml_prepare_features(sample_prices_weekly, sample_prices_daily,
                         include = c("mom12","vol20d_walign","rsi14"))
}
}
