% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ml.R
\name{demo_sector_map}
\alias{demo_sector_map}
\title{Demo sector (group) map for examples/tests}
\usage{
demo_sector_map(symbols, n_groups = 2L)
}
\arguments{
\item{symbols}{character vector of tickers.}

\item{n_groups}{integer number of groups to assign (cycled).}
}
\value{
A data.table with columns \code{Symbol} and \code{Group} (title-case), for demo use.
}
\description{
Demo sector (group) map for examples/tests
}
\examples{
# Minimal usage
syms <- c("AAPL","MSFT","AMZN","XOM","JPM")
gdf  <- demo_sector_map(syms, n_groups = 3L)  # columns: Symbol, Group
print(gdf)

# Use with cap_exposure(): convert to a named vector (names = symbols)
gmap <- stats::setNames(gdf$Group, gdf$Symbol)

data(sample_prices_weekly)
mom12 <- calc_momentum(sample_prices_weekly, 12)
sel10 <- filter_top_n(mom12, 10)
w_eq  <- weight_equally(sel10)

w_cap <- cap_exposure(
  weights          = w_eq,
  max_per_symbol   = 0.10,
  group_map        = gmap,     # <- named vector, OK for current cap_exposure()
  max_per_group    = 0.45,
  renormalize_down = TRUE
)
head(w_cap)

}
