# PeruAPIs

[![License: MIT](https://img.shields.io/badge/license-MIT-blue.svg)](LICENSE)

The `PeruAPIs` package provides a unified interface to access open data from the **World Bank API**, **Nager.Date API**, and the **REST Countries API**, with a focus on **Peru**. It allows users to retrieve up-to-date or historical information on topics such as economic indicators, demographics, national holidays, and key geopolitical details.

In addition to API-access functions, the package includes a curated collection of open datasets related to **Peru**. These datasets cover a wide range of topics including administrative divisions, electoral data, demographics, biodiversity and educational classifications.


## Installation

You can install the `PeruAPIs` package from CRAN with the following R function:

```R

install.packages("PeruAPIs")

```


## Usage

After installation, load the package and start exploring and using its functions and datasets.

```R

library(PeruAPIs)

```

## Functions for PeruAPIs


- `get_peru_child_mortality()`: Get Peru’s Under-5 Mortality Rate data from the World Bank.

- `get_peru_cpi()`: Get Peru’s Consumer Price Index (2010 = 100) data from the World Bank.

- `get_peru_energy_use()`: Get Peru’s Energy Use (kg of oil equivalent per capita) data from the World Bank.

- `get_peru_gdp()`: Get Peru’s GDP (current US$) data from the World Bank.

- `get_peru_holidays()`: Get official public holidays in Peru for a given year, e.g., `get_peru_holidays(2025)`.

- `get_peru_hospital_beds()`: Get Peru’s Hospital Beds (per 1,000 people) data from the World Bank.

- `get_peru_literacy_rate()`: Get Peru’s Adult Literacy Rate data from the World Bank.

- `get_peru_life_expectancy()`: Get Peru’s Life Expectancy at Birth data from the World Bank.

- `get_peru_population()`: Get Peru’s Total Population data from the World Bank.

- `get_peru_unemployment()`: Get Peru’s Total Unemployment Rate data from the World Bank.

- `get_country_info_pe()`: Get key country information for Peru.

- `view_datasets_PeruAPIs()`: View available curated datasets included in PeruAPIs.

## Dataset Suffixes

Each dataset in `PeruAPIs` is labeled with a *suffix* to indicate its structure and type:

- `_df`: A standard data frame.

- `_tbl_df`: A tibble data frame object.


## Datasets Included in PeruAPIs

In addition to API access functions, `PeruAPIs` provides a curated collection of open datasets focused on **Peru**. 

Below are some featured examples:

- **andean_migrants_health_df**: A data frame containing health data from a random sample of Peruvians born in the Andes mountains, but who have since migrated to lower altitudes.

- **birds_peru_tbl_df**: A tibble containing an updated list of bird species recorded in Peru, based on the most recent taxonomic revisions by the South American.

## Example Code:

```R

# Load the package

library(PeruAPIs)

# Retrieves essential information about Peru

get_country_info_pe()

# Get Peru's Population (Total) from World Bank

get_peru_population()

# Load a dataset

data(birds_peru_tbl_df)

# Shows six rows of the dataset

head(birds_peru_tbl_df)

# Display the structure of the dataset

str(birds_peru_tbl_df)

# Shows the whole dataset

View(birds_peru_tbl_df)


# Display all the datasets within PeruAPIs package

view_datasets_PeruAPIs()


```
