% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pspaceMethods.R
\docType{methods}
\name{circularProjection,PathwaySpace-method}
\alias{circularProjection,PathwaySpace-method}
\alias{circularProjection}
\title{Circular Projection of Graph-Associated Signals}
\usage{
\S4method{circularProjection}{PathwaySpace}(
  ps,
  k = 8,
  decay.fun = weibullDecay(),
  aggregate.fun = signalAggregation(),
  rescale = TRUE,
  verbose = TRUE,
  pdist = deprecated()
)
}
\arguments{
\item{ps}{A \linkS4class{PathwaySpace} class object.}

\item{k}{A single positive integer determining the k-top signals for the 
convolution operation.}

\item{decay.fun}{A signal decay function. Available options include 
'Weibull', 'exponential', and 'linear' (see \code{\link{weibullDecay}}).
Users may also define a custom decay model with at least two arguments, 
e.g., \code{function(x, signal) \{ ... \}}, which should returns a vector of  
projected signals of the same length as \code{x}. Additional arguments may  
include any variable available as a graph vertex attribute.}

\item{aggregate.fun}{A function used to aggregate the projected signals. 
It must be provided as a unary function, e.g., \code{function(x) { ... }}, 
which should aggregate a vector of signals to a scalar value. 
Available options include 'mean', 'wmean', 'log.wmean', and 'exp.wmean' 
(See \code{\link{signalAggregation}}).}

\item{rescale}{A logical value indicating whether to rescale 
the signal. If the signal \code{>=0}, then it will be rescaled to 
\code{[0, 1]}; if the signal \code{<=0}, then it will be rescaled to 
\code{[-1, 0]}; and if the signal in \code{(-Inf, +Inf)}, then it will be 
rescaled to \code{[-1, 1]}.}

\item{verbose}{A logical value specifying to display detailed 
messages (when \code{verbose=TRUE}) or not (when \code{verbose=FALSE}).}

\item{pdist}{Deprecated as of PathwaySpace 1.0.2; this parameter is now 
passed internally through \code{decay.fun}.}
}
\value{
A preprocessed \linkS4class{PathwaySpace} class object.
}
\description{
\code{circularProjection} implements a convolution
algorithm to project signals onto a 2D-coordinate system.
}
\examples{
# Load a demo igraph
data('gtoy1', package = 'RGraphSpace')

# Create a new PathwaySpace object
ps <- buildPathwaySpace(gtoy1, nrc = 100)
# note: adjust 'nrc' to increase image resolution

# Set '1s' as vertex signal
vertexSignal(ps) <- 1

# Create a 2D-landscape image
ps <- circularProjection(ps)

}
\seealso{
\code{\link{buildPathwaySpace}},  \code{\link{weibullDecay}},  
\code{\link{expDecay}}, \code{\link{linearDecay}}
}
\author{
Sysbiolab Team
}
