% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SparseSVM_solver.R
\name{SparseSVM_solver}
\alias{SparseSVM_solver}
\title{Solve given Sparse SVM problem in parametric simplex method}
\usage{
SparseSVM_solver(X, y, max_it = 50, lambda_threshold = 0.01)
}
\arguments{
\item{X}{\code{x} is an \code{n} by \code{d} data matrix}

\item{y}{\code{y} is a length \code{n} response vector}

\item{max_it}{This is the number of the maximum path length one would like to achieve. The default length is \code{50}.}

\item{lambda_threshold}{The parametric simplex method will stop when the calculated parameter is smaller than lambda. The default value is \code{0.01}.}
}
\value{
An object with S3 class \code{"primal"} is returned:
\item{data}{
  The \code{n} by \code{d} data matrix from the input
}
\item{response}{
  The length \code{n} response vector from the input
}
\item{beta}{
  A matrix of regression estimates whose columns correspond to regularization parameters for parametric simplex method.
}
\item{beta0}{
  A vector of regression estimates whose index correspond to regularization parameters for parametric simplex method.
}
\item{df}{
  The degree of freecom (number of nonzero coefficients) along the solution path.
}
\item{value}{
  The sequence of optimal value of the object function corresponded to the sequence of lambda.
}
\item{iterN}{
  The number of iteration in the program.
}
\item{lambda}{
  The sequence of regularization parameters \code{lambda} obtained in the program.
}
\item{type}{
  The type of the problem, such as \code{Dantzig} and \code{SparseSVM}.
}
}
\description{
Solve given Sparse SVM problem in parametric simplex method
}
\examples{
## SparseSVM
## We set the X matrix to be normal random matrix and Y is a vector consists of -1 and 1
## with the number of iteration to be 1000.
## Generate the design matrix and coefficient vector
n = 200 # sample number
d = 100 # sample dimension
c = 0.5 # correlation parameter
s = 20  # support size of coefficient
set.seed(1024)
X = matrix(rnorm(n*d),n,d)+c*rnorm(n)
## Generate response and solve the solution path
Y <- sample(c(-1,1),n,replace = TRUE)
## Sparse SVM solved with parametric simplex method
fit.SVM = SparseSVM_solver(X, Y, max_it = 1000, lambda_threshold = 0.01)
## lambdas used
print(fit.SVM$lambda)
## Visualize the solution path
plot(fit.SVM)
}
\seealso{
\code{\link{primal-package}}
}
