% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Graph.R
\name{remove_CondInd}
\alias{remove_CondInd}
\title{Remove elements from a conditioning set by using conditional independence}
\usage{
remove_CondInd(DAG, node, cond_set)
}
\arguments{
\item{DAG}{Directed Acyclic Graph}

\item{node}{node}

\item{cond_set}{vector of nodes in conditioning set}
}
\value{
a vector containing the nodes that cannot be removed from the
conditioning set.
}
\description{
Remove elements from a conditioning set by using conditional independence
}
\examples{

DAG = create_empty_DAG(3)
DAG = bnlearn::set.arc(DAG, 'U1', 'U3')
DAG = bnlearn::set.arc(DAG, 'U2', 'U3')

remove_CondInd(DAG = DAG, node = "U1", cond_set = c("U2"))
remove_CondInd(DAG = DAG, node = "U3", cond_set = c("U1"))

}
