% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCBN-simulation.R
\name{compute_sample_margin}
\alias{compute_sample_margin}
\title{Computes a conditional margin during sampling}
\usage{
compute_sample_margin(
  object,
  data,
  v,
  cond_set,
  check_PCBN = TRUE,
  verbose = 1
)
}
\arguments{
\item{object}{PCBN object to sample from.
\bold{This does not work if the PCBN does not abide by the B-sets.
And in general, it does not work if the PCBN is outside of
the class of restricted PCBNs.}}

\item{data}{data frame of observations of size \code{n}}

\item{v}{name of the node}

\item{cond_set}{conditioning set.
This is a vector containing the names of all the nodes in the conditioning set.}

\item{check_PCBN}{check whether the given PCBN satisfies the restrictions.
If this is set to \code{FALSE}, no checking is performed.
This means that the error due to the a non-restricted PCBN object (if this
is the case) will occur later in the computations (and may not be so clear -
typically it is because of failing to find a given conditional copula).}

\item{verbose}{if \code{0}, don't print anything.
If \code{verbose >= 1}, print information about the fitting procedure.}
}
\value{
a vector of size \eqn{n} of realizations \eqn{u_{i, v | cond\_set}}
for \eqn{i = 1, \dots, n}.
}
\description{
Computes a conditional margin during sampling
}
\examples{

DAG = create_empty_DAG(3)
DAG = bnlearn::set.arc(DAG, 'U1', 'U3')
DAG = bnlearn::set.arc(DAG, 'U2', 'U3')

order_hash = r2r::hashmap()
order_hash[['U3']] = c("U1", "U2")

fam = matrix(c(0, 0, 1,
               0, 0, 1,
               0, 0, 0), byrow = TRUE, ncol = 3)
tau = 0.2 * fam

my_PCBN = new_PCBN(
  DAG, order_hash,
  copula_mat = list(tau = tau, fam = fam))

# Initialize data frame
N = 100
nodes = bnlearn::nodes(my_PCBN$DAG)
data = data.frame(matrix(ncol = length(nodes), nrow = N))
colnames(data) <- nodes

data[, "U1"] = stats::runif(N)
data[, "U2"] = stats::runif(N)
u_1_given2 = compute_sample_margin(object = my_PCBN, data = data,
                                   v = "U1", cond_set = c("U2"))

identical(data[, "U1"], u_1_given2)

}
