#' Export Cleaned Omics Data
#'
#' Saves a cleaned omics dataset to a CSV file.
#'
#' @param data A cleaned omics data frame or matrix.
#' @param file_path Path to the file where the data will be saved.
#'
#' @return None. A file is written to disk.
#'
#' @examples
#' \donttest{
#' # Create sample data
#' data <- matrix(rnorm(100), nrow = 10)
#' cleaned_data <- as.data.frame(data)
#'
#' # Save to a temporary location (CRAN policy compliant)
#' temp_file <- tempfile(fileext = ".csv")
#' export_clean(cleaned_data, temp_file)
#' }
#'
#' @export
export_clean <- function(data, file_path) {
  utils::write.csv(data, file = file_path, row.names = FALSE)
  message(paste("Data exported successfully to", file_path))
}
