\name{stress66}
\alias{stress66}
\title{Breaking Stress of 66 Carbon Fibers of Length 50 mm}

\description{
This dataset contains the breaking stress (in GPa) of 66 carbon fibers of length
50 mm. The data were originally used by Nichols and Padgett (2006) in their study
on bootstrap control charts for Weibull percentiles.
}

\usage{
stress66
}

\format{
A numeric vector of length 66 containing breaking stress values measured in
gigapascals (GPa).
}

\value{
An object of class \code{"numeric"}.

The vector consists of 66 observed breaking stress measurements (in
gigapascals) for individual carbon fiber specimens of length 50 mm. Each value
represents the stress level at which a single fiber failed. The dataset is
commonly used in reliability analysis, survival modeling, and goodness-of-fit
studies involving strength and lifetime distributions, particularly Weibull
models and bootstrap-based control charts.
}

\details{
The carbon fiber breaking stress dataset is commonly used in reliability
analysis, survival models, and goodness-of-fit studies involving lifetime and
strength distributions. Nichols and Padgett (2006) applied these data in
developing bootstrap control charts based on Weibull percentiles.
}

\references{
Nichols, M. D., & Padgett, W. J. (2006). A Bootstrap Control Chart for Weibull
Percentiles. \emph{Quality and Reliability Engineering International}, 22(2),
141--151.
}

\examples{
summary(stress66)

plot(
  stress66,
  type = "h",
  main = "Breaking Stress Values",
  xlab = "Observation",
  ylab = "Stress (GPa)"
)

hist(
  stress66,
  main = "Histogram of Breaking Stress",
  xlab = "Stress (GPa)"
)
}

\keyword{datasets}
