% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NewLindleyHC.r
\name{NewLindleyHC}
\alias{NewLindleyHC}
\alias{dNLindley.HC}
\alias{pNLindley.HC}
\alias{qNLindley.HC}
\alias{rNLindley.HC}
\alias{hNLindley.HC}
\title{New Lindley Half-Cauchy Distribution}
\usage{
dNLindley.HC(x, lambda, theta, log = FALSE)
pNLindley.HC(q, lambda, theta, lower.tail = TRUE, log.p = FALSE)
qNLindley.HC(p, lambda, theta, lower.tail = TRUE, log.p = FALSE)
rNLindley.HC(n, lambda, theta)
hNLindley.HC(x, lambda, theta)
}
\arguments{
\item{x, q}{numeric vector of quantiles (x, q)}

\item{lambda}{positive numeric parameter}

\item{theta}{positive numeric parameter}

\item{log}{logical; if TRUE, returns log-density}

\item{lower.tail}{logical; if TRUE (default), probabilities are 
\eqn{P[X \le x]} otherwise, \eqn{P[X > x]}.}

\item{log.p}{logical; if TRUE, probabilities are given as log(p)}

\item{p}{numeric vector of probabilities (0 < p < 1)}

\item{n}{number of observations (integer > 0)}
}
\value{
\itemize{
  \item \code{dNLindley.HC}: numeric vector of (log-)densities
  \item \code{pNLindley.HC}: numeric vector of probabilities
  \item \code{qNLindley.HC}: numeric vector of quantiles
  \item \code{rNLindley.HC}: numeric vector of random variates
  \item \code{hNLindley.HC}: numeric vector of hazard values
}
}
\description{
Provides density, distribution, quantile, random generation,
and hazard functions for the New Lindley Half-Cauchy distribution.
}
\details{
The New Lindley Half-Cauchy distribution is parameterized by the parameters
\eqn{\lambda > 0}, and \eqn{\theta > 0}.


The New Lindley Half-Cauchy distribution has CDF:

\deqn{
F(x; \lambda, \theta) =
\left\{\frac{2}{\pi} \tan ^{-1}\left(\frac{x}{\lambda}\right)\right\}
^\theta\left\{1-\left(\frac{\theta}{1+\theta}\right) \ln \left[\frac{2}{\pi} 
\tan ^{-1}\left(\frac{x}{\lambda}\right)\right]\right\}  \quad ;\;x > 0.
}

where\eqn{\lambda} and \eqn{\theta} are the parameters.

The following functions are included:
\itemize{
  \item \code{dNLindley.HC()} — Density function
  \item \code{pNLindley.HC()} — Distribution function
  \item \code{qNLindley.HC()} — Quantile function
  \item \code{rNLindley.HC()} — Random generation
  \item \code{hNLindley.HC()} — Hazard function
}
}
\examples{
x <- seq(1, 10, 0.5)
dNLindley.HC(x, 0.5, 1.5)
pNLindley.HC(x, 0.5, 1.5)
qNLindley.HC(0.5, 0.5, 1.5)
rNLindley.HC(10, 0.5, 1.5)
hNLindley.HC(x, 0.5, 1.5)

# Data
x <- reactorpump
# ML estimates
params = list(lambda=0.7743, theta=1.3829)
#P–P (probability–probability) plot
pp.plot(x, params = params, pfun = pNLindley.HC, fit.line=TRUE)

#Q-Q (quantile–quantile) plot 
qq.plot(x, params = params, qfun = qNLindley.HC, fit.line=TRUE)

# Goodness-of-Fit(GoF) and Model Diagnostics 
out <- gofic(x, params = params,
             dfun = dNLindley.HC, pfun=pNLindley.HC, plot=TRUE)
print.gofic(out)

}
\references{
Chaudhary, A.K. & Kumar, V. (2020). 
New Lindley Half Cauchy Distribution: Theory and Applications. 
\emph{International Journal of Recent Technology and Engineering (IJRTE)}, 
\bold{9(4)}, 1--7. \doi{10.35940/ijrte.D4734.119420}
}
