% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NUtE.R
\name{NUtE}
\alias{NUtE}
\title{Calculate N Utilization Efficiency (NUtE)}
\usage{
NUtE(Yield, PlantN)
}
\arguments{
\item{Yield}{A numeric vector of yield values.}

\item{PlantN}{A numeric vector for plant tissue N.}
}
\value{
A numeric vector of NUtE values.
}
\description{
The contribution of fertilizer N from the plant tissues towards the yield component.
Formula: NUtE = Yield / PlantN
}
\examples{
Yield <- c(10, 12, 15)
PlantN <- c(2.5, 3.0, 3.2)
NUtE(Yield, PlantN)
}
