$SIZES LTH=27 LVR=29

$PROBLEM    031 SAEM

$INPUT NMROW ID TIME EVID CMT AMT DV MDV BBW DOSE ROW

$DATA NMsimData_xgxr032_sd1_NWPRI.csv
IGN=@

$SUBROUTINE ADVAN4 TRANS4

$PK
LTVKA=THETA(1)
LTVV2=THETA(2)
LTVCL=THETA(3)
LTVV3=THETA(4)
LTVQ=THETA(5)

MU_1=LTVKA
KA=EXP(MU_1+ETA(1))
MU_2=LTVV2
V2=EXP(MU_2+ETA(2))
MU_3=LTVCL
CL=EXP(MU_3+ETA(3))
MU_4=LTVV3
V3=EXP(MU_4+ETA(4))
MU_5 = LTVQ
Q =EXP(MU_5+ETA(5))
S2=V2

$ERROR
  IPRED=F
  IRES=DV-IPRED

  IF (IPRED.GT.1) THEN
    W = SQRT(IPRED**2*SIGMA(1,1) + SIGMA(2,2))
  ELSE
    W=1
  ENDIF

  IWRES=IRES/W
  Y=F+F*ERR(1)+ERR(2)

;-----------------------INITIAL ESTIMATES---------------------------------
$THETA
0.817093
4.32671
2.46238
5.39387
2.21507

$OMEGA 0 FIX
$OMEGA 0.173132
$OMEGA 0.324497
$OMEGA 0 FIX
$OMEGA 0 FIX

$SIGMA 0.0809353
$SIGMA 0 FIX



$PRIOR NWPRI PLEV=0.999000
$THETAP
0.817093 FIX
4.32671 FIX
2.46238 FIX
5.39387 FIX
2.21507 FIX
$THETAPV BLOCK(5) FIX 0.00421346
0.00216572 0.00341787
-0.0026693 -0.00208163 0.0119622
0.00802184 0.00513707 -0.0243139 0.076761
0.00111323 0.000867854 -0.0048564 0.0174466 0.00596833
$OMEGAP 0 FIX
$OMEGAP 0.173132
$OMEGAP 0.324497
$OMEGAP 0 FIX
$OMEGAP 0 FIX
$OMEGAPD 1 FIX
$OMEGAPD 55.6873669019155 FIX
$OMEGAPD 77.5098823609956 FIX
$OMEGAPD 1 FIX
$OMEGAPD 1 FIX
$SIGMAP 0.0809353
$SIGMAP 0 FIX
$SIGMAPD 440.853485944291 FIX
$SIGMAPD 1 FIX

$SIMULATION ONLYSIM (2342)
TRUE=PRIOR 

$TABLE NMROW ROW KA V2 V3 CL Q PRED IPRED Y NOPRINT FILE=xgxr032_sd1_NWPRI.tab

