% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pca_weights_one_country.R
\name{pca_weights_one_country}
\alias{pca_weights_one_country}
\title{Computes the PCA weights for a single country}
\usage{
pca_weights_one_country(Yields, Economy)
}
\arguments{
\item{Yields}{matrix (\code{J x Td}). Bond yields for a single country.}

\item{Economy}{character. Name of the economy.}
}
\value{
matrix (\code{J x J}). Eigenvectors of the variance-covariance matrix of yields.
}
\description{
Computes the PCA weights for a single country
}
\section{General Notation}{

\itemize{
  \item \code{Td}: model time series dimension
  \item \code{J}: number of bond yields per country used in estimation
}
}

\examples{
data(Yields)
Economy <- "Mexico"
pca_weights <- pca_weights_one_country(Yields, Economy)

}
