% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DatabasePrep.R
\name{DatabasePrep}
\alias{DatabasePrep}
\title{Gather data of several countries in a list. Particularly useful for GVAR-based setups (Compute "GVARFactors")}
\usage{
DatabasePrep(
  t_First,
  t_Last,
  Economies,
  N,
  FactorLabels,
  ModelType,
  Macro_FullData,
  Yields_FullData,
  Wgvar = NULL
)
}
\arguments{
\item{t_First}{character. Start date of the sample period in the format yyyy-mm-dd.}

\item{t_Last}{character. End date of the sample period in the format yyyy-mm-dd.}

\item{Economies}{character vector. Names of the \code{C} economies included in the system.}

\item{N}{positive integer. Number of country-specific spanned factors per country.}

\item{FactorLabels}{list. Labels for all variables present in the model, as returned by \code{\link{LabFac}}.}

\item{ModelType}{character. Model type to be estimated. Permissible choices: "JPS original", "JPS global", "GVAR single", "JPS multi", "GVAR multi", "JLL original", "JLL No DomUnit", "JLL joint Sigma".}

\item{Macro_FullData}{list. Full set of macroeconomic data, as returned by \code{\link{Load_Excel_Data}}.}

\item{Yields_FullData}{list. Full set of bond yield data, as returned by \code{\link{Load_Excel_Data}}.}

\item{Wgvar}{GVAR transition matrix. For GVAR models, either a matrix (\code{C x C}) for fixed weights, or a named list of matrices for time-varying weights. Default is NULL. Required for GVAR models.}
}
\value{
List containing the risk factor set for all countries and global factors. Particularly useful for GVAR-based models.
}
\description{
Gather data of several countries in a list. Particularly useful for GVAR-based setups (Compute "GVARFactors")
}
\section{General Notation}{

  \itemize{
    \item \code{C}: number of countries in the system.
    \item \code{N}: number of country-specific spanned factors.
  }
}

\examples{

# Load data from excel
macro_data <- Load_Excel_Data(system.file("extdata", "MacroData.xlsx", package = "MultiATSM"))
yields_data <- Load_Excel_Data(system.file("extdata", "YieldsData.xlsx", package = "MultiATSM"))
trade_data <- Load_Excel_Data(system.file("extdata", "TradeData.xlsx", package = "MultiATSM"))

# Adjust trade data
trade_data <- lapply(trade_data, function(df) {
  countries <- df[[1]]
  df <- as.data.frame(df[-1])
  rownames(df) <- countries
  df
})

# Define features of interest
ModelType <- "GVAR multi"
Economies <- c("China", "Uruguay", "Russia")
GlobalVar <- c("GBC", "CPI_OECD")
DomVar <- c("Eco_Act", "Inflation")
N <- 3
t0 <- "2006-09-01"
tF <- "2019-01-01"


# Compute some inputs
FactorLabels <- LabFac(N, DomVar, GlobalVar, Economies, ModelType)
Wgvar <- Transition_Matrix(
  t_First = "2006", t_Last = "2019", Economies,
  type = "Sample Mean", trade_data
)

# Compute GVARFactors
GVARFactors <- DatabasePrep(
  t0, tF, Economies, N, FactorLabels, ModelType, macro_data,
  yields_data, Wgvar
)

}
