% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gr-Coe.R
\name{hcontrib}
\alias{hcontrib}
\alias{hcontrib.OutCoe}
\title{Harmonic contribution to shape}
\usage{
hcontrib(Coe, ...)

\method{hcontrib}{OutCoe}(
  Coe,
  id,
  harm.r,
  amp.r = c(0, 0.5, 1, 2, 5, 10),
  main = "Harmonic contribution to shape",
  xlab = "Harmonic rank",
  ylab = "Amplification factor",
  ...
)
}
\arguments{
\item{Coe}{a \code{\link{Coe}} object (either \code{OutCoe} or (soon) \code{OpnCoe})}

\item{...}{additional parameter to pass to \code{\link{coo_draw}}}

\item{id}{the id of a particular shape, otherwise working on the meanshape}

\item{harm.r}{range of harmonics on which to explore contributions}

\item{amp.r}{a vector of numeric for multiplying coefficients}

\item{main}{a title for the plot}

\item{xlab}{a title for the x-axis}

\item{ylab}{a title for the y-axis}
}
\value{
a plot
}
\description{
Calculates contribution of harmonics to shape. The amplitude of every coefficients
of a given harmonic is multiplied by the coefficients provided and the resulting
shapes are reconstructed and plotted. Naturally, only works on Fourier-based methods.
}
\examples{
data(bot)
bot.f <- efourier(bot, 12)
hcontrib(bot.f)
hcontrib(bot.f, harm.r=3:10, amp.r=1:8, col="grey20",
   main="A huge panel")
}
\seealso{
Other Coe_graphics: 
\code{\link{boxplot.OutCoe}()}
}
\concept{Coe_graphics}
