% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{simuMSVAR}
\alias{simuMSVAR}
\title{Simulate Markov-switching vector autoregressive process}
\usage{
simuMSVAR(mdl_h0, burnin = 100)
}
\arguments{
\item{mdl_h0}{List containing the following DGP parameters
\itemize{
  \item n: Length of series.
  \item k: Number of regimes.
  \item mu: A (\code{k x q}) matrix of means.
  \item sigma: List with \code{k} (\code{q x q}) covariance matrices.
  \item phi: A (\code{q x qp}) matrix of autoregressive coefficients.
  \item p: Number of autoregressive lags.
  \item q: Number of series.
  \item P: A (\code{k x k}) transition matrix (columns must sum to one).
  \item eps: An optional (\code{T+burnin x q}) matrix with standard normal errors to be used. Errors will be generated if not provided.
}}

\item{burnin}{Number of simulated observations to remove from beginning. Default is \code{100}.}
}
\value{
List with simulated vector autoregressive series and its DGP parameters.
}
\description{
This function simulates a Markov-switching vector autoregressive process.
}
\examples{
set.seed(1234)
# Define DGP of MS VAR process
mdl_msvar2 <- list(n     = 1000, 
                   p     = 1,
                   q     = 2,
                   mu    = rbind(c(5, -2),
                                 c(10, 2)),
                   sigma = list(rbind(c(5.0, 1.5),
                                      c(1.5, 1.0)),
                                rbind(c(7.0, 3.0),
                                      c(3.0, 2.0))),
                   phi   = rbind(c(0.50, 0.30),
                                 c(0.20, 0.70)),
                   k     = 2,
                   P     = rbind(c(0.90, 0.10),
                                 c(0.10, 0.90)))

# Simulate process using simuMSVAR() function
y_msvar_simu <- simuMSVAR(mdl_msvar2)

plot(y_msvar_simu)
}
