% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Awatea2OM.R
\name{Awatea2OM}
\alias{Awatea2OM}
\title{Reads MCMC estimates from Awatea (Paul Starr) processed r file structure into an operating model}
\usage{
Awatea2OM(
  AwateaDir,
  nsim = 48,
  proyears = 50,
  Name = "OM made by Awatea2OM",
  Source = "No source provided",
  Author = "No author provided",
  verbose = TRUE
)
}
\arguments{
\item{AwateaDir}{A folder with Awatea files}

\item{nsim}{The number of simulations}

\item{proyears}{The number of projection years for the MSE}

\item{Name}{The name of the operating model}

\item{Source}{Reference to assessment documentation e.g. a url}

\item{Author}{Who did the assessment}

\item{verbose}{Return detailed messages?}
}
\description{
A function that generates an operating model from the MCMC samples of an Awatea model.
Code optimized for the BC Pacific ocean perch assessment (Haigh et al. 2018).
}
\details{
This function averages biological parameters across sex and then sends arrays to \link{VPA2OM}, assumes
unfished status (B/B0 = 1) in the first year, and assumes a single fishing fleet.
}
\references{
Haigh, R., et al. 2018. Stock assessment for Pacific Ocean Perch (\emph{Sebastes alutus}) in Queen Charlotte Sound, British Columbia in 2017.
Canadian Science Advisory Secretariat (CSAS) Research Document 2018/038. 232 pp.
\url{https://www.dfo-mpo.gc.ca/csas-sccs/Publications/ResDocs-DocRech/2018/2018_038-eng.html}
}
\author{
Q. Huynh and T. Carruthers
}
