% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ges_partial_ss_mix.R
\name{ges_partial_ss_mix}
\alias{ges_partial_ss_mix}
\alias{ges.partial.SS.mix}
\title{\eqn{\eta^2_{G}} (Partial Generalized Eta-Squared) for
Mixed Design ANOVA from \eqn{F}}
\usage{
ges_partial_ss_mix(dfm, dfe, ssm, sss, sse, f_value, a = 0.05, Fvalue)

ges.partial.SS.mix(dfm, dfe, ssm, sss, sse, Fvalue, a = 0.05)
}
\arguments{
\item{dfm}{degrees of freedom for the model/IV/between}

\item{dfe}{degrees of freedom for the error/residual/within}

\item{ssm}{sum of squares for the model/IV/between}

\item{sss}{sum of squares subject variance}

\item{sse}{sum of squares for the error/residual/within}

\item{f_value}{F statistic}

\item{a}{significance level}

\item{Fvalue}{Backward-compatible argument for the F statistic
(deprecated; use `f_value` instead). If supplied, it overrides `f_value`.
Included for users of the legacy `ges.partial.SS.mix()` API.}
}
\value{
\describe{
  \item{ges}{\eqn{\eta^2_{G}} effect size}
  \item{geslow}{lower level confidence interval for \eqn{\eta^2_{G}}}
  \item{geshigh}{upper level confidence interval for \eqn{\eta^2_{G}}}
  \item{dfm}{degrees of freedom for the model/IV/between}
  \item{dfe}{degrees of freedom for the error/residual/within}
  \item{F}{\eqn{F}-statistic}
  \item{p}{p-value}
  \item{estimate}{the \eqn{\eta^2_{G}} statistic and confidence
interval in APA style for markdown printing}
  \item{statistic}{the \eqn{F}-statistic in APA style for markdown printing}
}
}
\description{
This function displays partial generalized eta-squared
(\eqn{\eta^2_{G}}) from ANOVA analyses and its non-central
confidence interval based on the \eqn{F} distribution.
This formula works for mixed designs.
}
\details{
To calculate partial generalized eta squared, first, the sum of
squares of the model, sum of squares of the subject
variance, sum of squares for the subject variance,
and the sum of squares for the error/residual/within are added together.

\deqn{\eta^2_{G} = \frac{SS_M}{SS_M + SS_S + SS_E}}

\href{https://www.aggieerin.com/shiny-server/tests/gesmixss.html}{Learn more on our example page.}

**Note on function and output names:** This effect size is now implemented
with the snake_case function name `ges_partial_ss_mix()` to follow modern R
style guidelines. The original dotted version `ges.partial.SS.mix()` is
still available as a wrapper for backward compatibility, and both functions
return the same list. The returned object includes both the original
element names (e.g., `ges`, `geslow`, `geshigh`, `dfm`, `dfe`, `F`, `p`,
`estimate`, `statistic`) and newer snake_case aliases (e.g., `ges_value`,
`ges_lower_limit`, `ges_upper_limit`, `df_model`, `df_error`, `f_value`,
`p_value`). New code should prefer `ges_partial_ss_mix()` and the
snake_case output names, but existing code using the older names will
continue to work.
}
\examples{

# The following example is derived from the
# "mix2_data" dataset, included in the MOTE library.

# Given previous research, we know that backward strength in free
# association tends to increase the ratings participants give when
# you ask them how many people out of 100 would say a word in
# response to a target word (like Family Feud). This result is
# tied to people’s overestimation of how well they think they know
# something, which is bad for studying. So, we gave people instructions
# on how to ignore the BSG.  Did it help? Is there an interaction
# between BSG and instructions given?

# You would calculate one partial GES value for each F-statistic.
# Here's an example for the interaction using reported ANOVA values.
ges_partial_ss_mix(dfm = 1, dfe = 156,
                   ssm = 71.07608,
                   sss = 30936.498,
                   sse = 8657.094,
                   f_value = 1.280784, a = .05)

# Backwards-compatible dotted name (deprecated)
ges.partial.SS.mix(dfm = 1, dfe = 156,
                   ssm = 71.07608,
                   sss = 30936.498,
                   sse = 8657.094,
                   Fvalue = 1.280784, a = .05)

}
\keyword{ANOVA}
\keyword{effect}
\keyword{ges}
\keyword{size}
