% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_table.R
\name{summary_table}
\alias{summary_table}
\alias{summary_overview}
\alias{summary_metrics}
\title{Light exposure summary table helpers}
\usage{
summary_overview(
  dataset,
  Variable.colname = MEDI,
  coordinates = NULL,
  location = NULL,
  site = NULL,
  Datetime.colname = Datetime,
  Id.colname = Id,
  threshold.missing = 0.2,
  programmatic.use = FALSE,
  handle.gaps = TRUE
)

summary_metrics(
  dataset,
  Variable.colname = MEDI,
  Datetime.colname = Datetime,
  Id.colname = Id,
  threshold.missing = 0.2,
  programmatic.use = FALSE,
  handle.gaps = TRUE
)

summary_table(
  dataset,
  coordinates = NULL,
  location = NULL,
  site = NULL,
  color = "grey",
  Variable.colname = MEDI,
  Datetime.colname = Datetime,
  Id.colname = Id,
  threshold.missing = 0.2,
  Variable.label = "melanopic EDI (lx)",
  histograms = TRUE
)
}
\arguments{
\item{dataset}{A data frame containing light logger data.}

\item{Variable.colname}{Column containing light exposure values. Expects a
symbol; defaults to \code{MEDI} for compatibility with the built-in datasets.}

\item{coordinates}{Optional numeric vector of length two containing latitude
and longitude (in that order). If supplied, photoperiod information is
calculated when the dataset does not already contain a \code{photoperiod}
column.}

\item{location}{Optional location description (e.g. city name).}

\item{site}{Optional site description (e.g. country or study site).}

\item{Datetime.colname}{Column containing the timestamp information. Expects
a symbol; defaults to \code{Datetime}.}

\item{Id.colname}{Column containing the participant identifier. Expects a
symbol; defaults to \code{Id}.}

\item{threshold.missing}{Proportion of missing data (per participant-day)
tolerated before a day is considered incomplete.}

\item{programmatic.use}{Whether the function is used by another function.
This determines the number of columns to be output. Default is \code{FALSE}}

\item{handle.gaps}{Whether gaps in the data should be handled. Sets the
argument in \code{\link[=remove_partial_data]{remove_partial_data()}}. Default is \code{TRUE}.}

\item{color}{Color used for histogram accents in the metrics section.}

\item{Variable.label}{Label used in the table footnote to describe the light
variable.}

\item{histograms}{Logical indicating whether histogram spark lines should be
added for metrics where applicable.}
}
\value{
A tibble with overview metrics (\code{type}, \code{name}, \code{mean}, \code{SD}, \code{min},
\code{max}, \code{plot}). A \code{location_string} attribute is attached to the result for
use in \code{\link[=summary_table]{summary_table()}}. If \code{programmatic.use = FALSE}, \code{type}, \code{SD} and
\code{plot} are removed.

A tibble with summarized metrics across participant-days and
participant-level stability measures. Columns are compatible with
\code{\link[=summary_table]{summary_table()}}.

A \link[gt:gt]{gt} table.
}
\description{
These helpers create a publication-ready summary table for light logger
datasets. Users can either calculate the metrics, generate overview counts,
or render the complete \link[gt:gt]{gt} table.

This function creates a tibble that gives some high level information about a
dataset: How many participants are in there, the number of participant days,
how many participant days are complete above a given threshold, how much data
is missing, and (if provided) what the photoperiod is.
}
\details{
The function is used within \code{\link[=summary_table]{summary_table()}}.
}
\examples{
sample.data.environment |> summary_overview()
sample.data.irregular |> summary_overview()
\donttest{
sample.data.environment |> 
filter_Date(length = "3 days") |> 
summary_metrics()
  }

#sample.data.environment |> summary_table(coordinates = c(47,9))
}
