LSMrotate=function(z,w,method="chol"){
  ndim_z=ncol(w)
  if(ndim_z==1) stop("Rotation is not possible for 1 dimension")
  if(method=="chol"){
    rows=1:ndim_z
    cols=c(ndim_z,1:(ndim_z-1))
    w_top=w[rows,cols]
    w_top_rot=t(chol(w_top %*% t(w_top)))
    Rtmp=solve(w_top_rot,w_top)
    cols2=c(2:ndim_z,1)
    R=Rtmp[cols2,cols2]
    ind=which(diag(R)<0)  # to identify the sign (not strictly necessary, but good for comparison to other algorithms)
    R[ind,]=-R[ind,]
    wt=t(R%*%t(w))
    zt=t(R%*%t(z))
  }
  if(method=="stepwise"){
    ndim_z=ncol(w)
    if(ndim_z>3) stop("Stepwise rotation is only implemented for 2 or 3 dimensions")

    if(ndim_z==2){
      alpha=atan(w[1,1]/w[1,2])
      R=matrix(c(cos(alpha),-sin(alpha),sin(alpha),cos(alpha)),2,2,TRUE)
      ind=which(diag(R)<0)
      R[ind,]=-R[ind,]
      wt=t(R%*%t(w))
      zt=t(R%*%t(z))
    }
    if(ndim_z==3){
      R=diag(rep(1,3))
      r1=R
      alpha=atan(w[1,1]/w[1,3])
      r01=matrix(c(cos(alpha),-sin(alpha),sin(alpha),cos(alpha)),2,2,TRUE)
      r1[c(1,3),c(1,3)]=r01
      w1=t(r1%*%t(w))

      r2=R
      alpha=atan(w1[1,2]/w1[1,3])
      r02=matrix(c(cos(alpha),-sin(alpha),sin(alpha),cos(alpha)),2,2,TRUE)
      r2[c(2:3),c(2:3)]=r02
      w2=t(r2%*%t(w1))

      r3=R
      alpha=-atan(w2[2,2]/w2[2,1])
      r03=matrix(c(cos(alpha),-sin(alpha),sin(alpha),cos(alpha)),2,2,TRUE)
      r3[1:2,1:2]=r03

      R=r3%*%(r2%*%r1)
      ind=which(diag(R)<0)
      R[ind,]=-R[ind,]
      wt=t(R%*%t(w))
      zt=t(R%*%t(z))
    }
  }
    return(list(zt=zt,wt=wt,rotMat=R))
}
