% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{jpn_climate_tbl_df}
\alias{jpn_climate_tbl_df}
\title{Climate Data in Japan}
\format{
A tibble with 3,768 observations and 14 variables:
\describe{
  \item{no}{Observation number (numeric)}
  \item{station}{Name of the weather station (character)}
  \item{month}{Month of observation (numeric)}
  \item{temperature}{Average temperature (numeric)}
  \item{precipitation}{Monthly precipitation (numeric)}
  \item{snowfall}{Monthly snowfall (numeric)}
  \item{insolation}{Monthly solar insolation (numeric)}
  \item{country}{Country name (character)}
  \item{period}{Measurement period or time range (character)}
  \item{altitude}{Altitude of the station (numeric)}
  \item{latitude}{Latitude coordinate (numeric)}
  \item{longitude}{Longitude coordinate (numeric)}
  \item{NS}{Latitude direction, North or South (character)}
  \item{WE}{Longitude direction, West or East (character)}
}
}
\source{
Data taken from the clidatajp package version 0.5.2
}
\usage{
data(jpn_climate_tbl_df)
}
\description{
This dataset, jpn_climate_tbl_df, is a tibble containing climate data from various observation stations
across Japan. It includes monthly data on temperature, precipitation, snowfall, solar insolation,
and metadata such as station name, location, altitude, and coordinates.
}
\details{
The dataset name has been kept as 'jpn_climate_tbl_df' to avoid confusion with other datasets
in the R ecosystem. This naming convention helps distinguish this dataset as part of the
JapanAPIs package and assists users in identifying its specific characteristics.
The suffix 'tbl_df' indicates that the dataset is a tibble object. The original content has not been modified
in any way.
}
