% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{WestBengalPop_tbl_df}
\alias{WestBengalPop_tbl_df}
\title{West Bengal Population, Sex-Ratio, and Literacy Data (2011)}
\format{
A tibble with 23 observations and 8 variables:
\describe{
  \item{code}{Numeric district code (numeric)}
  \item{abbr}{District abbreviation (character)}
  \item{district}{Full district name (character)}
  \item{pop_2011}{Population in the year 2011 (numeric)}
  \item{pop_increase_2011}{Population increase percentage in 2011 compared to the previous census (numeric)}
  \item{sex_ratio_2011}{Sex ratio in 2011, expressed as females per 1,000 males (numeric)}
  \item{literacy_per_2011}{Literacy rate in 2011, expressed as a percentage (numeric)}
  \item{density_2011}{Population density in 2011 (persons per square kilometer) (numeric)}
}
}
\source{
Data taken from the \pkg{mapindia} package version 1.0.1
}
\usage{
data(WestBengalPop_tbl_df)
}
\description{
This dataset, WestBengalPop_tbl_df, is a tibble containing demographic data for
districts of West Bengal, India, based on the 2011 Census. It includes total
population, population increase percentage, sex ratio, literacy percentage,
and population density for each district.
}
\details{
The dataset name has been kept as 'WestBengalPop_tbl_df' to avoid confusion with other datasets
in the R ecosystem. This naming convention helps distinguish this dataset as part of the
IndiAPIs package and assists users in identifying its specific characteristics.
The suffix 'tbl_df' indicates that the dataset is a tibble object. The original content has not been modified
in any way.
}
