% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binomial.R
\name{iscaminvbinom}
\alias{iscaminvbinom}
\title{Inverse Binomial Probability}
\usage{
iscaminvbinom(alpha, n, prob, lower.tail, verbose = TRUE)
}
\arguments{
\item{alpha}{The probability of interest.}

\item{n}{The number of trials.}

\item{prob}{The probability of success.}

\item{lower.tail}{Boolean for finding the probability above (FALSE) or below (TRUE) the inputted value (inclusive)}

\item{verbose}{Logical, defaults to \code{TRUE}. Set to \code{FALSE} to suppress messages}
}
\value{
numeric which achieves at most the stated probability
}
\description{
Inverse Binomial Probability
}
\examples{
iscaminvbinom(alpha = 0.05, n = 30, prob = 0.5, lower.tail = TRUE)

iscaminvbinom(alpha = 0.05, n = 30, prob = 0.5, lower.tail = FALSE)

iscaminvbinom(alpha = 0.01, n = 60, prob = 0.10, lower.tail = FALSE)
}
