% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ar2cov.R
\name{ar2cov}
\alias{ar2cov}
\title{Illustrative code to compute the covariance of
the second order autoregression (AR2) model.}
\usage{
ar2cov(a1, a2, k = 30, useC = FALSE)
}
\arguments{
\item{a1}{the first auto-regression coefficient.}

\item{a2}{the second auto-regression coefficient.}

\item{k}{maximum lag for evaluating the auto-correlation.}

\item{useC}{just a test (to use C code).}
}
\value{
the autocorrelation as a vector or matrix,
whenever \code{a1} or \code{a2} are
scalar or vector.
}
\description{
Computes the auto-covariance for given coefficients.
}
\section{Details}{

Let the second order auto-regression model defined as
\verb{x_t + a_1 x_\{t-1\} + a_2 x_\{t-2\} = w_t}
where \code{w_t ~ N(0, 1)}.
}

\examples{
ar2cov(c(-1.7, -1.8), 0.963, k = 5)
plot(ar2cov(-1.7, 0.963), type = "o")
}
\seealso{
\link{ar2precision}
}
