% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HPZone_setup.R
\name{HPZone_setup}
\alias{HPZone_setup}
\title{Initialisation function to define API credentials. This function must be called before anything else, as the details supplied in this call are required for use.
Note that client_id and client_secret should preferably not be supplied in this call, but rather stored using [HPZone_store_credentials()].}
\usage{
HPZone_setup(
  client_id = NA,
  client_secret = NA,
  standard = "standard",
  extended = "extended",
  token_url = "https://connect.govconext.nl/oidc/token",
  data_url = "https://api.hpzone.nl:8899/Edie"
)
}
\arguments{
\item{client_id}{Client ID as supplied by InFact.}

\item{client_secret}{Client secret as supplied by InFact.}

\item{standard}{Name of the standard scope. Default: "standard"}

\item{extended}{Name of the extended scope. Default: "extended"}

\item{token_url}{Address of the token server.}

\item{data_url}{Address of the data server.}
}
\value{
No return value.
}
\description{
Initialisation function to define API credentials. This function must be called before anything else, as the details supplied in this call are required for use.
Note that client_id and client_secret should preferably not be supplied in this call, but rather stored using [HPZone_store_credentials()].
}
\examples{
# Not recommended:
HPZone_setup("id", "secret")

# Recommended:
\dontrun{
HPZone_store_credentials() # call once
HPZone_setup() # will automatically read stored credentials
}
}
