% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download_trend_tables.R
\name{download_trend_tables}
\alias{download_trend_tables}
\title{Download HCUP Summary Trend Tables}
\usage{
download_trend_tables(table_id = NULL, dest_dir = NULL, cache = TRUE)
}
\arguments{
\item{table_id}{Character string or numeric specifying which table to download.
Can be:
\itemize{
\item A table number (e.g., "1", "2a", "6b", "11c") for specific tables
\item "all" to download all available tables as a ZIP file
\item NULL (default) to show an interactive menu for selecting a table (in interactive sessions),
or return a list of available tables (in non-interactive sessions)
}}

\item{dest_dir}{Character string specifying the destination directory for the
downloaded file(s). If NULL (default), files are saved to a temporary directory.}

\item{cache}{Logical. If TRUE (default), downloaded files are cached to avoid
re-downloading on subsequent calls.}
}
\value{
If \code{table_id} is NULL and session is non-interactive, returns a data frame listing available tables.
Otherwise, returns the path(s) to the downloaded file(s).
}
\description{
Downloads HCUP Summary Trend Tables from the HCUP website. These tables provide
information on hospital utilization derived from HCUP databases, including trends
in inpatient and emergency department utilization.
}
\details{
The HCUP Summary Trend Tables include information on:
\itemize{
\item Overview of trends in inpatient and emergency department utilization
\item All inpatient encounter types
\item Inpatient encounter types (normal newborns, deliveries, elective/non-elective stays)
\item Inpatient service lines (maternal/neonatal, mental health, injuries, surgeries, etc.)
\item ED treat-and-release visits
}

Each table is available as an Excel file with state-specific, region-specific,
and national statistics.

The function automatically discovers available tables by scraping the HCUP website,
so it will automatically adapt to new tables or version changes.

For more information, see:
https://hcup-us.ahrq.gov/reports/trendtables/summarytrendtables.jsp
}
\examples{
\donttest{
# List available tables
available_tables <- download_trend_tables()
print(available_tables)

# Download a specific table
table_path <- download_trend_tables("2a")

# Download all tables
all_tables <- download_trend_tables("all")
}

}
