#' GraphRankTest: Rank-based Two-Sample Tests via Graph/Similarity-Induced Ranks
#'
#' The **GraphRankTest** package implements the RISE framework for
#' two-sample testing using rank/graph matrices constructed from either
#' raw data \eqn{X, Y} or a pre-computed similarity matrix \eqn{S}.
#'
#' @section Main function:
#' - \link[=RISE]{RISE()}: construct a nonnegative symmetric rank/graph matrix
#'   \eqn{R} (k-NN, k-MST, or minimum-distance pairing variants),
#'   and compute a Hotelling-type quadratic statistic with asymptotic and
#'   optional permutation p-values.
#'
#' @section Method overview:
#' From a similarity matrix \eqn{S}, the procedure builds \eqn{R} using one of:
#' - **RgNN / RoNN**: k-nearest-neighbor graph (graph-induced ranks vs. overall ranks)
#' - **RgMST / RoMST**: k-minimum spanning trees (graph-induced ranks vs. overall ranks)
#' - **RoMDP**: k-minimum-distance non-bipartite matchings (overall ranks)
#'
#' Let \eqn{U_x=\sum_{i,j\in X}R_{ij}}, \eqn{U_y=\sum_{i,j\in Y}R_{ij}}.
#' Under the permutation null, the centered vector \eqn{(U_x,U_y)} has a
#' tractable covariance, yielding a chi-square(2) limiting test.
#'
#' @section Getting started:
#' ```r
#' library(GraphRankTest)
#' ?RISE
#' help(package = "GraphRankTest")
#' ```
#'
#' @references
#' Zhou, D. and Chen, H. (2023).
#' *A new ranking scheme for modern data and its application to two-sample hypothesis testing*.
#' In *COLT 2023*, PMLR, 3615–3668.
#'
#' @seealso \link[=RISE]{RISE}
#' @docType package
#' @name GraphRankTest
#' @keywords internal
"_PACKAGE"
