% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_commits.R
\name{get_commits_stats}
\alias{get_commits_stats}
\title{Get commits statistics}
\usage{
get_commits_stats(
  commits,
  time_aggregation = c("year", "month", "week", "day"),
  group_var
)
}
\arguments{
\item{commits}{A \code{gitstats_commits} S3 class table object (output of \code{get_commits()}).}

\item{time_aggregation}{A character, specifying time aggregation of
statistics.}

\item{group_var}{Other grouping variable to be passed to \code{dplyr::group_by()}
function apart from \code{stats_date} and \code{githost}. Could be: \code{author},
\code{author_login}, \code{author_name} or \code{organization}. Should be passed without
quotation marks.}
}
\value{
A table of \code{commits_stats} class.
}
\description{
Prepare statistics from the pulled commits data.
}
\details{
To make function work, you need first to get commits data with
\code{GitStats}. See examples section.
}
\examples{
\dontrun{
 my_gitstats <- create_gitstats() \%>\%
   set_github_host(
     token = Sys.getenv("GITHUB_PAT"),
     repos = c("r-world-devs/GitStats", "openpharma/visR")
   ) |>
   get_commits(my_gitstats, since = "2022-01-01") |>
   get_commits_stats(
     time_aggregation = "year",
     group_var = author
   )
}
}
