% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_exposure.R
\name{simulate_exposure}
\alias{simulate_exposure}
\title{Simulate external exposure}
\usage{
simulate_exposure(
  x,
  expos_mean = "mean",
  expos_sd = "sd",
  expos_label = "casn",
  n = 1000
)
}
\arguments{
\item{x}{data frame or list of data frames containing exposure data.}

\item{expos_mean}{column name of mean values.}

\item{expos_sd}{column name of standard deviations.}

\item{expos_label}{column name of labeling term, required if \code{x} has more
than one row.}

\item{n}{simulated sample size(s).}
}
\value{
list of matrices containing inhalation rates. Matrix columns are
named using the values in the \code{expos_label} column for more than one data
frame row. Columns are sorted to have consistent order across functions.
}
\description{
Simulate external exposure
}
\details{
The sample size can be either a single value or a vector the same length as
the number of data frames in x. If a single value is provided, the same
sample size is used for all data frames. If a vector is provided, each
element corresponds to the sample size for each data frame in x.
}
\examples{
# Single data frame
x <- data.frame(mean = 1:3, sd = (1:3) / 10, casn = letters[1:3])
simulate_exposure(x, n = 5)

# List of 2 data frames
y <- data.frame(mean = 4:6, sd = 0.1, casn = letters[1:3])
simulate_exposure(list(loc1 = x, loc2 = y), n = 5)
# different sample sizes
simulate_exposure(list(loc1 = x, loc2 = y), n = c(5, 3))

# Input has custom column names
z <- data.frame(ave = 1:3, stdev = (1:3) / 10, chnm = letters[1:3])
simulate_exposure(z,
                  expos_mean = "ave",
                  expos_sd = "stdev",
                  expos_label = "chnm",
                  n = 5)

}
