#' Sample dataset to test GeneNMF installation
#'
#' A Seurat object containing single-cell transcriptomes
#' (scRNA-seq) for 50 cells and 20729 genes.
#' Single-cell UMI counts were normalized using a standard log-normalization:
#' counts for each cell were divided by the total counts for that cell and
#' multiplied by 10,000, then natural-log transformed using `log1p`. \cr\cr
#' This a subsample of 25 predicted B cells and 25 predicted NK cells from
#' the large scRNA-seq PBMC dataset published
#' by Hao et al. (\doi{10.1016/j.cell.2021.04.048}) and
#' available as UMI counts at
#' \url{https://atlas.fredhutch.org/data/nygc/multimodal/pbmc_multimodal.h5seurat}
#' 
#' @format A sparse matrix of 50 cells and 20729 genes.
#' @source \doi{10.1016/j.cell.2021.04.048}
"sampleObj"