% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GRAND.R
\name{GRAND.evaluate}
\alias{GRAND.evaluate}
\title{GRAND Evaluation of Network Data}
\usage{
GRAND.evaluate(
  result,
  statistics = c("degree", "vshape", "triangle", "eigen", "harmonic")
)
}
\arguments{
\item{result}{List. Output from GRAND.privatize function containing privatization results.}

\item{statistics}{Character vector. Network statistics to evaluate. Options include:
"degree" (Node Degree), "vshape" (V-Shape Count), "triangle" (Triangle Count), "eigen" (Eigen Centrality), "harmonic" (Harmonic Centrality). Default is all statistics.}
}
\value{
A data frame containing evaluation results with columns:
\itemize{
  \item stat: Type of network statistic(s) evaluated
  \item eps: Privacy budget parameter(s) used
  \item Hat: Wasserstein distance for release set estimation
  \item Hat2: Wasserstein distance for holdout set estimation
  \item GRAND: Wasserstein distance for GRAND privatization method
  \item Laplace: Wasserstein distance for standard Laplace mechanism
}
}
\description{
Evaluates the quality of GRAND privatization results by comparing
various network statistics between the original and privatized networks using
Wasserstein distance.
}
\details{
GRAND Evaluation of Network Data


  This function evaluates privatization quality by comparing network statistics between 
  original and privatized networks using Wasserstein-1 distance. The evaluation covers:
  \itemize{
    \item \strong{Hat}: Performance on release set (without privacy)
    \item \strong{Hat2}: Performance on holdout set (without privacy)
    \item \strong{GRAND}: Performance of GRAND privatization method
    \item \strong{Laplace}: Performance of standard Laplace mechanism
  }
  Lower Wasserstein distances indicate better utility preservation.

  For more details, see the "simulation experiments" section of Liu, Bi, and Li (2025).
}
\examples{
# Generate and privatize a network
network <- LSM.Gen(n = 400, k = 2, K = 3, avg.d = 40)
result <- GRAND.privatize(A = network$A, K = 2, idx = 1:200, eps = c(1, 2, 5, 10), model = "LSM")
# Evaluate results for all statistics
evaluation <- GRAND.evaluate(result)
# Evaluate only degree and triangle statistics
evaluation_subset <- GRAND.evaluate(result, statistics = c("degree", "triangle"))
}
\references{
S. Liu, X. Bi, and T. Li. GRAND: Graph Release with Assured Node Differential Privacy. 
  arXiv preprint arXiv:2507.00402, 2025.
}
