% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.GPTCM.R
\name{predict.GPTCM}
\alias{predict.GPTCM}
\title{Prediction of survival probability}
\usage{
\method{predict}{GPTCM}(object, dat, newdata = NULL, type = "survival", times = NULL, ...)
}
\arguments{
\item{object}{the results of a \code{GPTCM} fit}

\item{dat}{the dataset used in \code{GPTCM()}}

\item{newdata}{optional new data at which to do predictions. If missing, the
prediction will be based on the training data}

\item{type}{the type of predicted value. Currently it is only valid with
\code{'survival'}}

\item{times}{evaluation time points for survival prediction. Default
\code{NULL} for predicting all time points in the \code{newdata} set}

\item{...}{for future methods}
}
\value{
A matrix object
}
\description{
Compute predicted survival probability for a GPTCM
}
\examples{

# simulate data
set.seed(123)
n <- 200 # subjects
p <- 10 # variable selection predictors
L <- 3 # cell types
dat <- simData(n, p, L)

# run a Bayesian GPTCM model: GPTCM-Ber2
fit <- GPTCM(dat, nIter = 10, burnin = 0)

pred.survival <- predict(fit, dat, newdata = dat, times = c(1, 3, 5))

}
\references{
Zhao Z, Kızılaslan F, Wang S, Zucknick M (2025). \emph{Generalized promotion time cure model: A new modeling framework to identify cell-type-specific genes and improve survival prognosis}. arXiv:2509.01001
}
