% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_coef_crosspred.R
\name{plot_coef_crosspred}
\alias{plot_coef_crosspred}
\title{Plot \code{crosspred} Objects: Overall, Slices, or Heatmap}
\usage{
plot_coef_crosspred(
  crosspred,
  type = c("heatmap", "slices", "overall"),
  var = NULL,
  lag = NULL,
  exp = FALSE,
  palette = "-RdBu",
  n_lag_smooth = 50,
  line_color = "black",
  line_size = 0.7,
  ribbon_color = NULL,
  ribbon_alpha = 0.2,
  title = "",
  ylab = NULL,
  xlab = NULL,
  ...
)
}
\arguments{
\item{crosspred}{An object of class \code{"crosspred"} or \code{"GHR_crosspred"},
produced by \code{\link[dlnm]{crosspred}} or \code{\link[GHRmodel]{crosspred_inla}}.}

\item{type}{Character string. Options: \code{"overall"}, \code{"slices"}, or \code{"heatmap"}.}

\item{var}{Optional numeric vector of exposure values (used when \code{type = "slices"} to plot across lags).}

\item{lag}{Optional numeric vector of lag values (used when \code{type = "slices"} to plot across variables).}

\item{exp}{Logical. If \code{TRUE}, exponentiates the results (e.g., for log or logit links).}

\item{palette}{Character string for heatmap palette when \code{type = "heatmap"}. Options:
\code{GHR}, \code{RColorBrewer} or \code{colorspace} palette (e.g. "Purp").}

\item{n_lag_smooth}{Integer, number of interpolation points along lag for heatmap smoothing (default = 50).}

\item{line_color}{Character string. Line color when \code{type = "slices"} or
\code{type = "overall"}. Default is "black".}

\item{line_size}{Numeric. Line width (default = 0.7).}

\item{ribbon_color}{Character string. Color for credible interval ribbons.
Defaults to \code{line_color}.}

\item{ribbon_alpha}{Numeric. Alpha transparency for ribbons (default = 0.2).}

\item{title}{Character string. Plot title.}

\item{ylab}{Character string. Label for y-axis.}

\item{xlab}{Character string. Label for x-axis.}

\item{...}{Additional arguments passed to \code{ggplot2} functions.}
}
\value{
A \code{ggplot} object for the specified plot type.
}
\description{
Generate plots from a \code{"crosspred"} object.
Three plot types are available:
\itemize{
\item \code{type = "overall"}: Shows the overall exposure–response relationship, aggregated across all lags.
\item \code{type = "slices"}: Produces line plots with credible interval ribbons, either
across lags (for a fixed \code{var}) or across values of \code{var} (for a fixed \code{lag}).
\item \code{type = "heatmap"}: Displays a two-dimensional heatmap of effects across both
\code{var} and \code{lag}. Not applicable for one-basis models.
}
}
\examples{
# Load example GHRmodels object from the package
model_dlnm_file <- system.file("examples", "model_dlnm.rds", package = "GHRmodel")
model_dlnm <- readRDS(model_dlnm_file)

# Load example cross-basis matrix from the package: 2-dimensional cross-basis matrix of the 
# non-linear effect of dengue risk across tmin values and lags: 
cb_tmin_file <- system.file("examples","cb_tmin.rds", package = "GHRmodel")
cb_tmin <- readRDS(cb_tmin_file) # loads cross-basis matrix into the environment

# Generate predictions
pred_result <- crosspred_inla(
  models    = model_dlnm,
  basis    = cb_tmin,
  mod_id = "mod3",
  at       = seq(17, 24, by = 1),  # e.g., temperature sequence
  lag      = 2,
  cen      = 20,
  ci.level = 0.95
)


# Plot DLNM predictions 
plot_coef_crosspred(
crosspred = pred_result,    # Crosspred object with model predictions
type = "slices",            # Plot temperature-specific slices of exposure-response curves
exp = TRUE,                 # Exponentiate the coefficients (to relative risk scale)
var = c(22:24),             # Display results for temperature 22°C to 24°C
line_color = "red",         # Red color for the lines representing effect estimates
line_size = 0.8,            # Line thickness set to 0.8 for better visibility
ribbon_color = "red",       # Red shading for credible interval ribbons
ribbon_alpha = 0.3,         # Set ribbon transparency to 30\%
title = "Effect of minimum temperatures 22°C to 23°C on dengue relative risk by lag",
xlab = "Lag",               # Label for the x-axis (exposure variable)
ylab = "Relative Risk (RR)" # Label for the y-axis (effect estimate scale)
)

}
\seealso{
\code{\link[dlnm]{crosspred}}
}
