% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main_functions.R
\name{GCC}
\alias{GCC}
\title{Generalised canonical correlation estimation for the global factors}
\usage{
GCC(
  data,
  standarise = TRUE,
  r_max = 10,
  r0 = NULL,
  ri = NULL,
  depvar_header = NULL,
  i_header = NULL,
  j_header = NULL,
  t_header = NULL
)
}
\arguments{
\item{data}{Either a data.frame or a list of data matrices of length \eqn{R}. See \strong{Details}.}

\item{standarise}{A logical indicating whether the data is standardised before estimation or not. See \strong{Details}.}

\item{r_max}{An integer indicating the maximum number of factors allowed. See \strong{Details}.}

\item{r0}{An integer of the number of global factors. See \strong{Details}.}

\item{ri}{An array of length \eqn{R} containing the number of local factors in each block. See \strong{Details}.}

\item{depvar_header}{A character string specifying the header of the dependent variable. See \strong{Details}.}

\item{i_header}{A character string specifying the header of the block identifier. See \strong{Details}.}

\item{j_header}{A character string specifying the header of the individual identifier. See \strong{Details}.}

\item{t_header}{A character string specifying the header of the time identifier. See \strong{Details}.}
}
\value{
A list containing the estimated number of global factors \eqn{\hat{r}_{0}},
the global factors \eqn{\widehat{\boldsymbol{G}}}, and the other elements that are
used in multilevel().
}
\description{
This function is one of the main functions the package, employing the
generalized canonical correlation estimation for both the global factors
\eqn{\boldsymbol{G}} and, when not explicitly provided, for the number of
global factors \eqn{r_{0}}. Typically, this function is intended for internal
purposes. Users can opt for [GCC()] instead of [multilevel()], if they only
need to estimate the number of global factors.
}
\details{
The user-supplied data.frame should contain at least four columns, namely the
dependent variable (\eqn{y_{ijt}}), block identifier (\eqn{i}), individual
identifier (\eqn{j}), and time (\eqn{t}). The user needs to supply their corresponding
headers in the data.frame to the function using the parameters "depvar_header",
"i_header", "j_header", and "t_header", respectively. If the data is supplied
as a list, these arguments will not be used.

If either r0 = NULL or ri = NULL, both of them will be estimated.
In such case, "r_max" must be supplied. If "r0" and "ri" are supplied then
"r_max" is not needed and will be ignored.

If standarise = TRUE, each time series will be standardised so it has zero mean
and unit variance.
}
\examples{

panel <- UKhouse # load the data
Y_list <- panel2list(panel, depvar_header = "dlPrice", i_header = "Region",
                                       j_header = "LPA_Type", t_header = "Date")
est_GCC <- GCC(Y_list, r_max = 10)
r0_hat <- est_GCC$r0 # number of global factors
G_hat <- est_GCC$G # global factors
}
\references{
Lin, R. and Shin, Y., 2025. Generalised Canonical Correlation Estimation
of the Multilevel Factor Model. Available at SSRN 4783804.
}
