% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GBOP2_maxP_TE.gbop2.R
\name{GBOP2_maxP_TE}
\alias{GBOP2_maxP_TE}
\title{PSOGO: Power maximizing design with efficacy and toxicity boundaries}
\arguments{
\item{design}{fixed as "optimal", cannot be modified by user}

\item{pso_method}{method for single PSO, choose from "default", "quantum" or "dexp"}

\item{nlooks}{number of interim looks}

\item{skip_efficacy}{default is NULL, indicate skip efficacy as 1 and not skip as 0 in a vector}

\item{skip_toxicity}{default is NULL, indicate skip toxicity as 1 and not skip as 0 in a vector}

\item{totalPatients}{number of total patients}

\item{Nmin_cohort1}{maximum number of patients}

\item{Nmin_increase}{minimum number of first cohort}

\item{p01}{H0 for efficacy}

\item{p02}{H0 for toxicity}

\item{p03}{H0 for Eff and Tox}

\item{p11}{H1 for efficacy}

\item{p12}{H1 for toxicity}

\item{p13}{H1 for Eff and Tox}

\item{err_eff}{Type I error rate: Efficacious but toxic}

\item{err_tox}{Type I error rate: Safe but futile}

\item{err_all}{Type I error rate: Futile and toxic}

\item{power_all}{power: Futile and toxic}

\item{nSwarm}{nSwarm in PSO}

\item{maxIter}{maxIter in PSO}

\item{nParallel}{number of PSO ensemble}

\item{seed}{Random seed for reproducibility}
}
\value{
A list on design parameters and operating characteristics
}
\description{
This function implements PSOGO to find a power maximizing design with efficacy and toxicity boundaries.
}
\details{
Parallel computing is only used when the user explicitly sets nCore > 1. No more than 2 cores should be used
unless the user is aware and permits it. The function defaults to sequential execution. If multiple analyses
are planned, consider using `init_cluster(nCore)` and `stop_cluster()` manually to control the backend.
}
\examples{
\donttest{
# init_cluster(2)
# GBOP2_maxP_TE(
# design = "optimal",
# nlooks = 1,
# skip_efficacy = NULL,
# skip_toxicity = NULL,
# totalPatients = 50,
# Nmin_cohort1 = 10,
# Nmin_increase = 5,
# p01 = 0.15,  
# p02 = 0.16,  
# p03 = 0.024, 
# p11 = 0.4,  
# p12 = 0.08,  
# p13 = 0.032, 
# err_eff = 1,  
# err_tox = 1 , 
# err_all = 0.1,  
# power_all = 0.8,
# nParallel = 3,
# seed = 5321,
# pso_method = "default",
# nSwarm = 32,
# maxIter = 100)
# stop_cluster()  # Only if init_cluster() was used
#  
message("Run GBOP2_minSS_singleE() manually for real optimization.")
}

 
}
