% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crown_diameter_silva.R
\name{crown_diameter_silva_core}
\alias{crown_diameter_silva_core}
\title{Core function for the silva tree crown diameter calculation}
\usage{
crown_diameter_silva_core(species_id, dbh_cm, height_m)
}
\arguments{
\item{species_id}{Vector of species ids
(see \code{\link{crown_diameter_silva}}), but for this core function to work,
\code{species_id} must be provided as \code{character}. This will and should
be not checked inside this function, because if used as intended, that has
happened before calling it.}

\item{dbh_cm}{Vector of breast height diameters
(see \code{\link{crown_diameter_silva}})}

\item{height_m}{Vector of tree heights
(see \code{\link{crown_diameter_silva}})}
}
\value{
Tree crown diameter (see \code{\link{crown_diameter_silva}})
}
\description{
See documentation of \code{\link{crown_diameter_silva}} for most information,
this function is the workhorse behind, and should never be called directly by
a user.
}
\details{
The function \code{crown_diameter_silva} is fully vectorized, inputs are
recycled according to the tibble rules
}
\keyword{internal}
