% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions.R
\name{get_Sig_e1_approx}
\alias{get_Sig_e1_approx}
\title{Approximate the long-run covariance matrix \eqn{\Gamma_{\boldsymbol{\epsilon}}(0)}}
\usage{
get_Sig_e1_approx(Sig_nu, Phi, m = 6)
}
\arguments{
\item{Sig_nu}{Numeric \eqn{p \times p} matrix representing the innovation
covariance \eqn{\Sigma_{\boldsymbol{\nu}}}.}

\item{Phi}{Numeric \eqn{p \times p} autoregressive coefficient matrix
\eqn{\Phi}.}

\item{m}{Integer (default = 6). Number of lag terms used in the truncated
series expansion. Larger values yield higher accuracy but increase
computation time.}
}
\value{
A numeric \eqn{p \times p} matrix giving the approximate
\eqn{\Gamma_{\boldsymbol{\epsilon}}(0)}.
}
\description{
Computes an approximate long-run covariance matrix
\eqn{\Gamma_{\boldsymbol{\epsilon}}(0)} for the stationary VAR(1)
process
\deqn{\boldsymbol{\epsilon}_t = \Phi \boldsymbol{\epsilon}_{t-1} + \boldsymbol{\nu}_t,}
where \eqn{\boldsymbol{\nu}_t} has innovation covariance
\eqn{\Sigma_{\boldsymbol{\nu}}}. The approximation is obtained via a
truncated series expansion up to order `m`.
}
\details{
For a stable VAR(1) process, the theoretical long-run covariance satisfies
\deqn{\mathrm{vec}(\Gamma_{\boldsymbol{\epsilon}}(0)) =
(I_{p^2} - \Phi \otimes \Phi)^{-1} \mathrm{vec}(\Sigma_{\boldsymbol{\nu}}).}
To avoid matrix inversion, this function approximates the inverse by the
truncated Neumann series:
\deqn{(I_{p^2} - \Phi \otimes \Phi)^{-1} =
I_{p^2} + \sum_{i=1}^{m} (\Phi^{\otimes i}),}
where \eqn{\Phi^{\otimes i}} denotes the Kronecker product of
\eqn{\Phi^i} with itself. The truncation level `m` controls the
approximation accuracy.
}
