% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions.R
\name{add_jumps}
\alias{add_jumps}
\title{Add mean shifts to multivariate time series data}
\usage{
add_jumps(data, delta, num)
}
\arguments{
\item{data}{Numeric matrix of dimension \eqn{n \times p}, representing the
time series data.}

\item{delta}{Numeric vector of length \eqn{p}, specifying the shift
magnitudes added to each variable after each change point.}

\item{num}{Integer; number of change points. The data are divided evenly
into \code{num} + 1 segments, and \code{delta} is added cumulatively after
each change point.}
}
\value{
A numeric matrix of the same dimension as `data`, containing the adjusted
series with added mean shifts.
}
\description{
Adds constant mean shifts to a multivariate time series by applying a fixed
jump vector at evenly spaced change points. After each change point, all
subsequent observations are shifted by the specified vector.
}
\details{
The total length of the time series is denoted by \eqn{n}. Change points are
placed at evenly spaced locations given by
\eqn{k \lfloor n / (num + 1) \rfloor}, for \eqn{k = 1, \ldots, num}. After each
change point, a constant shift vector \code{delta} is added to all subsequent
observations. This construction produces synthetic data with known and
controlled mean shifts, making the function useful for simulation studies and
benchmarking change point detection methods.
}
