% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select_mtd.R
\name{select_mtd}
\alias{select_mtd}
\title{Select the maximum tolerated dose (MTD) using isotonic regression}
\usage{
select_mtd(method,
                  pT,
                  EI,
                  n_obs,
                  y_obs,
                  DU.pp=0.95,
                  extrasafe = FALSE)
}
\arguments{
\item{method}{the design name; only i3+3 and BOIN are accepted.}

\item{pT}{a numeric value; the target DLT rate.}

\item{EI}{a vector which specifies the equivalence interval (EI).}

\item{n_obs}{a vector containing the number of participants treated at each dose level.}

\item{y_obs}{a vector containing the number of participants who experienced dose-limiting toxicity at each dose level.}

\item{DU.pp}{a numeric value; the cutoff to remove an overly toxic dose for safety.
We recommend the default value of (\code{DU.pp=0.95}) for general use.}

\item{extrasafe}{a logical value which specifies whether to implement a more strict safety rule.}
}
\value{
\code{select_mtd()} returns the selected MTD dose (\code{$d_selected})
}
\description{
Select the maximum tolerated dose (MTD) when the trial is completed using isotonic regression
}
\details{
\code{select_mtd()} selects the MTD based on isotonic estimates of toxicity
         probabilities. If there are ties, we select from the ties the highest dose
         level when the estimate of the DLT rate is smaller than the target, or the
         lowest dose level when the estimate of the DLT rate is greater than the target.
         The isotonic estimates are obtained by the pooled-adjacent-violators algorithm
         (PAVA) (Barlow, 1972).
}
