% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coefs.R
\name{coef.gmjmcmc}
\alias{coef.gmjmcmc}
\title{Coefficients for GMJMCMC Model}
\usage{
\method{coef}{gmjmcmc}(object, ...)
}
\arguments{
\item{object}{Object of class "gmjmcmc".}

\item{...}{Additional arguments (ignored).}
}
\value{
Vector of coefficients from the best model found.
}
\description{
Extracts coefficients from the best GMJMCMC model found.
}
\examples{
data(exoplanet)
model <- fbms(semimajoraxis ~ ., data = exoplanet, method = "gmjmcmc", transforms = c("sigmoid"))
coef(model)
}
