% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/key_functions.R
\encoding{UTF-8}
\name{hazard_rate_key}
\alias{hazard_rate_key}
\title{Hazard rate key function}
\usage{
hazard_rate_key(x, sigma, beta)
}
\arguments{
\item{x}{vector of perpendicular distances from the transect.}

\item{sigma}{scale parameter.}

\item{beta}{shape parameter.}
}
\value{
A numeric value corresponding to a given value of \code{x},
\code{sigma} and \code{beta}.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

This function provides the hazard rate key function for model fitting in
distance sampling.
}
\details{
This is the hazard rate key function with parameters
\code{sigma} and \code{beta}. Its expression is given by

\eqn{g(x) = 1 - \exp((\frac{-x}{\sigma})^{-\beta},}

for x > 0.
}
\examples{
library(EstimationTools)

#----------------------------------------------------------------------------
# Example: Hazard rate function
hazard_rate_key(x=1, sigma=2, beta=3)
curve(hazard_rate_key(x, sigma=2, beta=3), from=0, to=10, ylab='g(x)')

#----------------------------------------------------------------------------
}
\seealso{
Other key functions: 
\code{\link{half_norm_key}()},
\code{\link{uniform_key}()}
}
\author{
Jaime Mosquera Gutiérrez, \email{jmosquerag@unal.edu.co}
}
\concept{key functions}
