#' Liver Cancer Data 2
#'
#' A sample of 1,736 patients who have been diagnosed with liver cancer between 2012 and 2016, whose cancer grades are well identified. Available individual-level covariates include age at diagnosis, sex, race, grade of liver cancer, median household income, time to treatment, tumor size, radiation indicator, and chemotherapy indicator. The grade of diseas is categorized into four levels: well-differentiated (Grade I), moderately differentiated (Grade II), poorly differentiated (Grade III), and undifferentiated/anaplastic (Grade IV).
#'
#' @docType data
#' @name liver2
#' @usage data(liver2)
#' @format A data frame with 1,736 observations and 10 variables:
#' \describe{
#'   \item{ID}{Unique patient identifier}
#'   \item{time}{Survival time in months}
#'   \item{status}{censored = 0, dead due to liver cancer = 1}
#'   \item{sex}{Sex of patient: Male=1, Female=0}
#'   \item{age}{Scaled age of diagnosis}
#'   \item{medh}{Scaled median household income of the subject}
#'   \item{race}{While = 1, Other = 0}
#'   \item{grade}{Pathological grade of liver cancer}
#'   \item{chemo}{chemotherapy = 1, non = 0}
#'   \item{radio}{radiation = 1, non = 0}
#' }
#'
#' @examples
#' data(liver2)
#' head(liver2)
NULL
