% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/net.loads.R
\name{net.loads}
\alias{net.loads}
\title{Network Loadings}
\usage{
net.loads(
  A,
  wc,
  loading.method = c("original", "revised"),
  scaling = 2,
  rotation = NULL,
  ordered = c("descending", "variable"),
  ...
)
}
\arguments{
\item{A}{Network matrix, data frame, or \code{\link[EGAnet]{EGA}} object}

\item{wc}{Numeric or character vector (length = \code{ncol(A)}).
A vector of community assignments.
If input into \code{A} is an \code{\link[EGAnet]{EGA}} object,
then \code{wc} is automatically detected}

\item{loading.method}{Character (length = 1).
Sets network loading calculation based on implementation
described in \code{"original"} (Christensen & Golino, 2021) or
the \code{"revised"} (Christensen et al., 2024) implementation.
Defaults to \code{"revised"}}

\item{scaling}{Numeric (length = 1).
Scaling factor for the magnitude of the \code{"experimental"} network loadings.
Defaults to \code{2}.
\code{10} makes loadings roughly the size of factor loadings when correlations
between factors are orthogonal}

\item{rotation}{Character (length = 1).
A rotation to use to obtain a simpler structure.
For a list of rotations, see \code{\link[GPArotation]{rotations}} for options.
Defaults to \code{NULL} or no rotation.
By setting a rotation, \code{scores} estimation will be
based on the rotated loadings rather than unrotated loadings}

\item{ordered}{Character (length = 1).
How the loadings should be ordered in the output.
Available options:

\itemize{

\item \code{"descending"} (default) --- Sorts loadings in descending
order on their assigned community. This option is best for interpretation

\item \code{"variable"} --- Keeps variables in the same order as the
original network. This option is best for analyses

}}

\item{...}{Additional arguments to pass on to \code{\link[GPArotation]{rotations}}}
}
\value{
Returns a list containing:

\item{unstd}{A matrix of the unstandardized within- and between-community
strength values for each node}

\item{std}{A matrix of the standardized within- and between-community
strength values for each node}

\item{rotated}{\code{NULL} if \code{rotation = NULL}; otherwise,
a list containing the rotated standardized network loadings
(\code{loadings}) and correlations between dimensions (\code{Phi})
from the rotation}
}
\description{
Computes the between- and within-community
\code{strength} of each variable for each community
}
\details{
Simulation studies have demonstrated that a node's strength
centrality is roughly equivalent to factor loadings
(Christensen & Golino, 2021; Hallquist, Wright, & Molenaar, 2019).
Hallquist and colleagues (2019) found that node strength represented a
combination of dominant and cross-factor loadings. This function computes
each node's strength within each specified dimension, providing a rough
equivalent to factor loadings (including cross-loadings; Christensen & Golino, 2021).
}
\examples{
# Load data
wmt <- wmt2[,7:24]

# Estimate EGA
ega.wmt <- EGA(
  data = wmt,
  plot.EGA = FALSE # No plot for CRAN checks
)

# Network loadings
net.loads(ega.wmt)

}
\references{
\strong{Original implementation and simulation} \cr
Christensen, A. P., & Golino, H. (2021).
On the equivalency of factor and network loadings.
\emph{Behavior Research Methods}, \emph{53}, 1563-1580.

\strong{Demonstration of node strength similarity to CFA loadings} \cr
Hallquist, M., Wright, A. C. G., & Molenaar, P. C. M. (2019).
Problems with centrality measures in psychopathology symptom networks: Why network psychometrics cannot escape psychometric theory.
\emph{Multivariate Behavioral Research}, 1-25.

\strong{Revised network loadings} \cr
Christensen, A. P., Golino, H., Abad, F. J., & Garrido, L. E. (2025).
Revised network loadings.
\emph{Behavior Research Methods}, 57, 114.
}
\author{
Alexander P. Christensen <alexpaulchristensen@gmail.com> and Hudson Golino <hfg9s at virginia.edu>
}
